<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cities ServiceType
 * @subpackage Services
 */
class Cities extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeZip_GetCities
     * Meta information extracted from the WSDL
     * - documentation: Return the list of cities for given zip code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeZip_GetCities $parameters
     * @return \GlsPoland\StructType\AdeZip_GetCitiesResponse|bool
     */
    public function adeZip_GetCities(\GlsPoland\StructType\AdeZip_GetCities $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_GetCities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeZip_GetCitiesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
