<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for COD ServiceType
 * @subpackage Services
 */
class COD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetMaxCOD
     * Meta information extracted from the WSDL
     * - documentation: Return maximum amount of COD.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetMaxCOD $parameters
     * @return \GlsPoland\StructType\AdeServices_GetMaxCODResponse|bool
     */
    public function adeServices_GetMaxCOD(\GlsPoland\StructType\AdeServices_GetMaxCOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxCOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetMaxCODResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
