<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearanceImporter StructType
 * @subpackage Structs
 */
class CBulkCustomsClearanceImporter extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceAddress
     */
    public $address;
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceContactPerson
     */
    public $contactPerson;
    /**
     * The isCommercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isCommercial;
    /**
     * The eoriNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eoriNumber;
    /**
     * The taxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $taxId;
    /**
     * Constructor method for cBulkCustomsClearanceImporter
     * @uses CBulkCustomsClearanceImporter::setAddress()
     * @uses CBulkCustomsClearanceImporter::setContactPerson()
     * @uses CBulkCustomsClearanceImporter::setIsCommercial()
     * @uses CBulkCustomsClearanceImporter::setEoriNumber()
     * @uses CBulkCustomsClearanceImporter::setTaxId()
     * @param \GlsPoland\StructType\CBulkCustomsClearanceAddress $address
     * @param \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson
     * @param bool $isCommercial
     * @param string $eoriNumber
     * @param string $taxId
     */
    public function __construct(\GlsPoland\StructType\CBulkCustomsClearanceAddress $address = null, \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson = null, $isCommercial = null, $eoriNumber = null, $taxId = null)
    {
        $this
            ->setAddress($address)
            ->setContactPerson($contactPerson)
            ->setIsCommercial($isCommercial)
            ->setEoriNumber($eoriNumber)
            ->setTaxId($taxId);
    }
    /**
     * Get address value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceAddress
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceAddress $address
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function setAddress(\GlsPoland\StructType\CBulkCustomsClearanceAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get contactPerson value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceContactPerson
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function setContactPerson(\GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson = null)
    {
        $this->contactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get isCommercial value
     * @return bool
     */
    public function getIsCommercial()
    {
        return $this->isCommercial;
    }
    /**
     * Set isCommercial value
     * @param bool $isCommercial
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function setIsCommercial($isCommercial = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommercial) && !is_bool($isCommercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommercial, true), gettype($isCommercial)), __LINE__);
        }
        $this->isCommercial = $isCommercial;
        return $this;
    }
    /**
     * Get eoriNumber value
     * @return string|null
     */
    public function getEoriNumber()
    {
        return $this->eoriNumber;
    }
    /**
     * Set eoriNumber value
     * @param string $eoriNumber
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function setEoriNumber($eoriNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eoriNumber) && !is_string($eoriNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eoriNumber, true), gettype($eoriNumber)), __LINE__);
        }
        $this->eoriNumber = $eoriNumber;
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->taxId;
    }
    /**
     * Set taxId value
     * @param string $taxId
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->taxId = $taxId;
        return $this;
    }
}
