<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearance StructType
 * @subpackage Structs
 */
class CBulkCustomsClearance extends AbstractStructBase
{
    /**
     * The parcelNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\ArrayType\CStringArray
     */
    public $parcelNumbers;
    /**
     * The glsIncotermCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $glsIncotermCode;
    /**
     * The totalGrossWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CWeightExt
     */
    public $totalGrossWeight;
    /**
     * The exporter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public $exporter;
    /**
     * The importer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public $importer;
    /**
     * The invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceInvoice
     */
    public $invoice;
    /**
     * The lineItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray
     */
    public $lineItems;
    /**
     * The customerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReference;
    /**
     * The isExportDeclarationRequested
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isExportDeclarationRequested;
    /**
     * The exportDeclarationNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\ArrayType\CStringArray
     */
    public $exportDeclarationNumbers;
    /**
     * The transitMRNs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\ArrayType\CStringArray
     */
    public $transitMRNs;
    /**
     * The transitType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transitType;
    /**
     * The consignee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\StructType\CBulkCustomsClearanceConsignee
     */
    public $consignee;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray
     */
    public $documents;
    /**
     * Constructor method for cBulkCustomsClearance
     * @uses CBulkCustomsClearance::setParcelNumbers()
     * @uses CBulkCustomsClearance::setGlsIncotermCode()
     * @uses CBulkCustomsClearance::setTotalGrossWeight()
     * @uses CBulkCustomsClearance::setExporter()
     * @uses CBulkCustomsClearance::setImporter()
     * @uses CBulkCustomsClearance::setInvoice()
     * @uses CBulkCustomsClearance::setLineItems()
     * @uses CBulkCustomsClearance::setCustomerReference()
     * @uses CBulkCustomsClearance::setIsExportDeclarationRequested()
     * @uses CBulkCustomsClearance::setExportDeclarationNumbers()
     * @uses CBulkCustomsClearance::setTransitMRNs()
     * @uses CBulkCustomsClearance::setTransitType()
     * @uses CBulkCustomsClearance::setConsignee()
     * @uses CBulkCustomsClearance::setDocuments()
     * @param \GlsPoland\ArrayType\CStringArray $parcelNumbers
     * @param string $glsIncotermCode
     * @param \GlsPoland\StructType\CWeightExt $totalGrossWeight
     * @param \GlsPoland\StructType\CBulkCustomsClearanceExporter $exporter
     * @param \GlsPoland\StructType\CBulkCustomsClearanceImporter $importer
     * @param \GlsPoland\StructType\CBulkCustomsClearanceInvoice $invoice
     * @param \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray $lineItems
     * @param string $customerReference
     * @param bool $isExportDeclarationRequested
     * @param \GlsPoland\ArrayType\CStringArray $exportDeclarationNumbers
     * @param \GlsPoland\ArrayType\CStringArray $transitMRNs
     * @param string $transitType
     * @param \GlsPoland\StructType\CBulkCustomsClearanceConsignee $consignee
     * @param \GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray $documents
     */
    public function __construct(\GlsPoland\ArrayType\CStringArray $parcelNumbers = null, $glsIncotermCode = null, \GlsPoland\StructType\CWeightExt $totalGrossWeight = null, \GlsPoland\StructType\CBulkCustomsClearanceExporter $exporter = null, \GlsPoland\StructType\CBulkCustomsClearanceImporter $importer = null, \GlsPoland\StructType\CBulkCustomsClearanceInvoice $invoice = null, \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray $lineItems = null, $customerReference = null, $isExportDeclarationRequested = null, \GlsPoland\ArrayType\CStringArray $exportDeclarationNumbers = null, \GlsPoland\ArrayType\CStringArray $transitMRNs = null, $transitType = null, \GlsPoland\StructType\CBulkCustomsClearanceConsignee $consignee = null, \GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray $documents = null)
    {
        $this
            ->setParcelNumbers($parcelNumbers)
            ->setGlsIncotermCode($glsIncotermCode)
            ->setTotalGrossWeight($totalGrossWeight)
            ->setExporter($exporter)
            ->setImporter($importer)
            ->setInvoice($invoice)
            ->setLineItems($lineItems)
            ->setCustomerReference($customerReference)
            ->setIsExportDeclarationRequested($isExportDeclarationRequested)
            ->setExportDeclarationNumbers($exportDeclarationNumbers)
            ->setTransitMRNs($transitMRNs)
            ->setTransitType($transitType)
            ->setConsignee($consignee)
            ->setDocuments($documents);
    }
    /**
     * Get parcelNumbers value
     * @return \GlsPoland\ArrayType\CStringArray
     */
    public function getParcelNumbers()
    {
        return $this->parcelNumbers;
    }
    /**
     * Set parcelNumbers value
     * @param \GlsPoland\ArrayType\CStringArray $parcelNumbers
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setParcelNumbers(\GlsPoland\ArrayType\CStringArray $parcelNumbers = null)
    {
        $this->parcelNumbers = $parcelNumbers;
        return $this;
    }
    /**
     * Get glsIncotermCode value
     * @return string
     */
    public function getGlsIncotermCode()
    {
        return $this->glsIncotermCode;
    }
    /**
     * Set glsIncotermCode value
     * @param string $glsIncotermCode
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setGlsIncotermCode($glsIncotermCode = null)
    {
        // validation for constraint: string
        if (!is_null($glsIncotermCode) && !is_string($glsIncotermCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glsIncotermCode, true), gettype($glsIncotermCode)), __LINE__);
        }
        $this->glsIncotermCode = $glsIncotermCode;
        return $this;
    }
    /**
     * Get totalGrossWeight value
     * @return \GlsPoland\StructType\CWeightExt
     */
    public function getTotalGrossWeight()
    {
        return $this->totalGrossWeight;
    }
    /**
     * Set totalGrossWeight value
     * @param \GlsPoland\StructType\CWeightExt $totalGrossWeight
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setTotalGrossWeight(\GlsPoland\StructType\CWeightExt $totalGrossWeight = null)
    {
        $this->totalGrossWeight = $totalGrossWeight;
        return $this;
    }
    /**
     * Get exporter value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function getExporter()
    {
        return $this->exporter;
    }
    /**
     * Set exporter value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceExporter $exporter
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setExporter(\GlsPoland\StructType\CBulkCustomsClearanceExporter $exporter = null)
    {
        $this->exporter = $exporter;
        return $this;
    }
    /**
     * Get importer value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceImporter
     */
    public function getImporter()
    {
        return $this->importer;
    }
    /**
     * Set importer value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceImporter $importer
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setImporter(\GlsPoland\StructType\CBulkCustomsClearanceImporter $importer = null)
    {
        $this->importer = $importer;
        return $this;
    }
    /**
     * Get invoice value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceInvoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceInvoice $invoice
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setInvoice(\GlsPoland\StructType\CBulkCustomsClearanceInvoice $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get lineItems value
     * @return \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray
     */
    public function getLineItems()
    {
        return $this->lineItems;
    }
    /**
     * Set lineItems value
     * @param \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray $lineItems
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setLineItems(\GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray $lineItems = null)
    {
        $this->lineItems = $lineItems;
        return $this;
    }
    /**
     * Get customerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @param string $customerReference
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Get isExportDeclarationRequested value
     * @return bool|null
     */
    public function getIsExportDeclarationRequested()
    {
        return $this->isExportDeclarationRequested;
    }
    /**
     * Set isExportDeclarationRequested value
     * @param bool $isExportDeclarationRequested
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setIsExportDeclarationRequested($isExportDeclarationRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportDeclarationRequested) && !is_bool($isExportDeclarationRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportDeclarationRequested, true), gettype($isExportDeclarationRequested)), __LINE__);
        }
        $this->isExportDeclarationRequested = $isExportDeclarationRequested;
        return $this;
    }
    /**
     * Get exportDeclarationNumbers value
     * @return \GlsPoland\ArrayType\CStringArray|null
     */
    public function getExportDeclarationNumbers()
    {
        return $this->exportDeclarationNumbers;
    }
    /**
     * Set exportDeclarationNumbers value
     * @param \GlsPoland\ArrayType\CStringArray $exportDeclarationNumbers
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setExportDeclarationNumbers(\GlsPoland\ArrayType\CStringArray $exportDeclarationNumbers = null)
    {
        $this->exportDeclarationNumbers = $exportDeclarationNumbers;
        return $this;
    }
    /**
     * Get transitMRNs value
     * @return \GlsPoland\ArrayType\CStringArray|null
     */
    public function getTransitMRNs()
    {
        return $this->transitMRNs;
    }
    /**
     * Set transitMRNs value
     * @param \GlsPoland\ArrayType\CStringArray $transitMRNs
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setTransitMRNs(\GlsPoland\ArrayType\CStringArray $transitMRNs = null)
    {
        $this->transitMRNs = $transitMRNs;
        return $this;
    }
    /**
     * Get transitType value
     * @return string|null
     */
    public function getTransitType()
    {
        return $this->transitType;
    }
    /**
     * Set transitType value
     * @param string $transitType
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setTransitType($transitType = null)
    {
        // validation for constraint: string
        if (!is_null($transitType) && !is_string($transitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transitType, true), gettype($transitType)), __LINE__);
        }
        $this->transitType = $transitType;
        return $this;
    }
    /**
     * Get consignee value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceConsignee|null
     */
    public function getConsignee()
    {
        return $this->consignee;
    }
    /**
     * Set consignee value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceConsignee $consignee
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setConsignee(\GlsPoland\StructType\CBulkCustomsClearanceConsignee $consignee = null)
    {
        $this->consignee = $consignee;
        return $this;
    }
    /**
     * Get documents value
     * @return \GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param \GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray $documents
     * @return \GlsPoland\StructType\CBulkCustomsClearance
     */
    public function setDocuments(\GlsPoland\ArrayType\CBulkCustomsClearanceAttachedFilesArray $documents = null)
    {
        $this->documents = $documents;
        return $this;
    }
}
