<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Allowed ServiceType
 * @subpackage Services
 */
class Allowed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetAllowed
     * Meta information extracted from the WSDL
     * - documentation: Get allowed services for user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetAllowed $parameters
     * @return \GlsPoland\StructType\AdeServices_GetAllowedResponse|bool
     */
    public function adeServices_GetAllowed(\GlsPoland\StructType\AdeServices_GetAllowed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetAllowed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetAllowedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
