<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dictionary ServiceType
 * @subpackage Services
 */
class Dictionary extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePfc_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePfc_GetDictionary $parameters
     * @return \GlsPoland\StructType\AdePfc_GetDictionaryResponse|bool
     */
    public function adePfc_GetDictionary(\GlsPoland\StructType\AdePfc_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeSendAddr_GetDictionary $parameters
     * @return \GlsPoland\StructType\AdeSendAddr_GetDictionaryResponse|bool
     */
    public function adeSendAddr_GetDictionary(\GlsPoland\StructType\AdeSendAddr_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePfc_GetDictionaryResponse|\GlsPoland\StructType\AdeSendAddr_GetDictionaryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
