<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Number ServiceType
 * @subpackage Services
 */
class Number extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePartner_GetParcelNumber
     * Meta information extracted from the WSDL
     * - documentation: Search for partner parcel number based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePartner_GetParcelNumber $parameters
     * @return \GlsPoland\StructType\AdePartner_GetParcelNumberResponse|bool
     */
    public function adePartner_GetParcelNumber(\GlsPoland\StructType\AdePartner_GetParcelNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePartner_GetParcelNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePartner_GetParcelNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
