<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_Get
     * Meta information extracted from the WSDL
     * - documentation: Get info about pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_Get $parameters
     * @return \GlsPoland\StructType\AdePickup_GetResponse|bool
     */
    public function adePickup_Get(\GlsPoland\StructType\AdePickup_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeTrackID_Get
     * Meta information extracted from the WSDL
     * - documentation: Search for TrackID based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeTrackID_Get $parameters
     * @return \GlsPoland\StructType\AdeTrackID_GetResponse|bool
     */
    public function adeTrackID_Get(\GlsPoland\StructType\AdeTrackID_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeTrackID_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Get
     * Meta information extracted from the WSDL
     * - documentation: Get system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeOption_Get $parameters
     * @return \GlsPoland\StructType\AdeOption_GetResponse|bool
     */
    public function adeOption_Get(\GlsPoland\StructType\AdeOption_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePOD_Get
     * Meta information extracted from the WSDL
     * - documentation: Get POD pdf file for parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePOD_Get $parameters
     * @return \GlsPoland\StructType\AdePOD_GetResponse|bool
     */
    public function adePOD_Get(\GlsPoland\StructType\AdePOD_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePOD_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeOption_GetResponse|\GlsPoland\StructType\AdePickup_GetResponse|\GlsPoland\StructType\AdePOD_GetResponse|\GlsPoland\StructType\AdeTrackID_GetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
