<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Country ServiceType
 * @subpackage Services
 */
class Country extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeParcelShop_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop_GetByCountry $parameters
     * @return \GlsPoland\StructType\AdeParcelShop_GetByCountryResponse|bool
     */
    public function adeParcelShop_GetByCountry(\GlsPoland\StructType\AdeParcelShop_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop2_GetByCountry $parameters
     * @return \GlsPoland\StructType\AdeParcelShop2_GetByCountryResponse|bool
     */
    public function adeParcelShop2_GetByCountry(\GlsPoland\StructType\AdeParcelShop2_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop3_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 3)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop3_GetByCountry $parameters
     * @return \GlsPoland\StructType\AdeParcelShop3_GetByCountryResponse|bool
     */
    public function adeParcelShop3_GetByCountry(\GlsPoland\StructType\AdeParcelShop3_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop3_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeParcelShop2_GetByCountryResponse|\GlsPoland\StructType\AdeParcelShop3_GetByCountryResponse|\GlsPoland\StructType\AdeParcelShop_GetByCountryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
