<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Active ServiceType
 * @subpackage Services
 */
class Active extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeProfile_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active profile info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeProfile_GetActive $parameters
     * @return \GlsPoland\StructType\AdeProfile_GetActiveResponse|bool
     */
    public function adeProfile_GetActive(\GlsPoland\StructType\AdeProfile_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active language.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLang_GetActive $parameters
     * @return \GlsPoland\StructType\AdeLang_GetActiveResponse|bool
     */
    public function adeLang_GetActive(\GlsPoland\StructType\AdeLang_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLang_GetActiveResponse|\GlsPoland\StructType\AdeProfile_GetActiveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
