<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Logout ServiceType
 * @subpackage Services
 */
class Logout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLogout
     * Meta information extracted from the WSDL
     * - documentation: Logout from ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLogout $parameters
     * @return \GlsPoland\StructType\AdeLogoutResponse|bool
     */
    public function adeLogout(\GlsPoland\StructType\AdeLogout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLogoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
