<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Labels ServiceType
 * @subpackage Services
 */
class Labels extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsignLabels $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignLabels(\GlsPoland\StructType\AdePreparingBox_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (via consign ids array)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsignsLabels $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignsLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignsLabels(\GlsPoland\StructType\AdePreparingBox_GetConsignsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetLabels $parameters
     * @return \GlsPoland\StructType\AdePickup_GetLabelsResponse|bool
     */
    public function adePickup_GetLabels(\GlsPoland\StructType\AdePickup_GetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignLabels $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignLabelsResponse|bool
     */
    public function adePickup_GetConsignLabels(\GlsPoland\StructType\AdePickup_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get parcels labels from pickup (array nums on input)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetParcelsLabels $parameters
     * @return \GlsPoland\StructType\AdePickup_GetParcelsLabelsResponse|bool
     */
    public function adePickup_GetParcelsLabels(\GlsPoland\StructType\AdePickup_GetParcelsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignLabelsResponse|\GlsPoland\StructType\AdePickup_GetLabelsResponse|\GlsPoland\StructType\AdePickup_GetParcelsLabelsResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignLabelsResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignsLabelsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
