<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ext ServiceType
 * @subpackage Services
 */
class Ext extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_InsertExt
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box (version with Customs Declaration).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_InsertExt $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_InsertExtResponse|bool
     */
    public function adePreparingBox_InsertExt(\GlsPoland\StructType\AdePreparingBox_InsertExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_InsertExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsignLabelsExt $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignLabelsExtResponse|bool
     */
    public function adePreparingBox_GetConsignLabelsExt(\GlsPoland\StructType\AdePreparingBox_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignLabelsExt $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignLabelsExtResponse|bool
     */
    public function adePickup_GetConsignLabelsExt(\GlsPoland\StructType\AdePickup_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignLabelsExtResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignLabelsExtResponse|\GlsPoland\StructType\AdePreparingBox_InsertExtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
