<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_ParcelNumberSearch
     * Meta information extracted from the WSDL
     * - documentation: Search for consignment based on number of parcel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_ParcelNumberSearch $parameters
     * @return \GlsPoland\StructType\AdePickup_ParcelNumberSearchResponse|bool
     */
    public function adePickup_ParcelNumberSearch(\GlsPoland\StructType\AdePickup_ParcelNumberSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_ParcelNumberSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_ParcelNumberSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
