<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeCourier_Order
     * Meta information extracted from the WSDL
     * - documentation: Order courier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeCourier_Order $parameters
     * @return \GlsPoland\StructType\AdeCourier_OrderResponse|bool
     */
    public function adeCourier_Order(\GlsPoland\StructType\AdeCourier_Order $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeCourier_Order($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeCourier_OrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
