<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeProfile_Change
     * Meta information extracted from the WSDL
     * - documentation: Change profile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeProfile_Change $parameters
     * @return \GlsPoland\StructType\AdeProfile_ChangeResponse|bool
     */
    public function adeProfile_Change(\GlsPoland\StructType\AdeProfile_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_Change
     * Meta information extracted from the WSDL
     * - documentation: Change language
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLang_Change $parameters
     * @return \GlsPoland\StructType\AdeLang_ChangeResponse|bool
     */
    public function adeLang_Change(\GlsPoland\StructType\AdeLang_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLang_ChangeResponse|\GlsPoland\StructType\AdeProfile_ChangeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
