<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRS ServiceType
 * @subpackage Services
 */
class SRS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetCountriesSRS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SRS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetCountriesSRS $parameters
     * @return \GlsPoland\StructType\AdeServices_GetCountriesSRSResponse|bool
     */
    public function adeServices_GetCountriesSRS(\GlsPoland\StructType\AdeServices_GetCountriesSRS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSRS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetCountriesSRSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
