<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Label ServiceType
 * @subpackage Services
 */
class Label extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from preparing box
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetParcelLabel $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetParcelLabelResponse|bool
     */
    public function adePreparingBox_GetParcelLabel(\GlsPoland\StructType\AdePreparingBox_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetParcelLabel $parameters
     * @return \GlsPoland\StructType\AdePickup_GetParcelLabelResponse|bool
     */
    public function adePickup_GetParcelLabel(\GlsPoland\StructType\AdePickup_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetParcelLabelResponse|\GlsPoland\StructType\AdePreparingBox_GetParcelLabelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
