<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_Create
     * Meta information extracted from the WSDL
     * - documentation: Create pickup from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_Create $parameters
     * @return \GlsPoland\StructType\AdePickup_CreateResponse|bool
     */
    public function adePickup_Create(\GlsPoland\StructType\AdePickup_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeBulkCustomsClearance_Create
     * Meta information extracted from the WSDL
     * - documentation: Create customs declaration for list of parcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeBulkCustomsClearance_Create $parameters
     * @return \GlsPoland\StructType\AdeBulkCustomsClearance_CreateResponse|bool
     */
    public function adeBulkCustomsClearance_Create(\GlsPoland\StructType\AdeBulkCustomsClearance_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeBulkCustomsClearance_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeBulkCustomsClearance_CreateResponse|\GlsPoland\StructType\AdePickup_CreateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
