<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for CDX ServiceType
 * @subpackage Services
 */
class CDX extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetCountriesCDX
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries, maximum CDX amount and currency supporting CDX service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetCountriesCDX $parameters
     * @return \GlsPoland\StructType\AdeServices_GetCountriesCDXResponse|bool
     */
    public function adeServices_GetCountriesCDX(\GlsPoland\StructType\AdeServices_GetCountriesCDX $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesCDX($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetCountriesCDXResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
