<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearanceLineItem StructType
 * @subpackage Structs
 */
class CBulkCustomsClearanceLineItem extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CQuantityExt
     */
    public $quantity;
    /**
     * The commodityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commodityCode;
    /**
     * The goodsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $goodsDescription;
    /**
     * The countryOfOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The valueInInvoiceCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $valueInInvoiceCurrency;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CWeightExt
     */
    public $grossWeight;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CWeightExt
     */
    public $netWeight;
    /**
     * The preferentialTrade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade
     */
    public $preferentialTrade;
    /**
     * The statisticalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\StructType\CAmountOfMoney
     */
    public $statisticalValue;
    /**
     * The statisticalQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $statisticalQuantity;
    /**
     * The nationalCustomsFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields
     */
    public $nationalCustomsFields;
    /**
     * Constructor method for cBulkCustomsClearanceLineItem
     * @uses CBulkCustomsClearanceLineItem::setQuantity()
     * @uses CBulkCustomsClearanceLineItem::setCommodityCode()
     * @uses CBulkCustomsClearanceLineItem::setGoodsDescription()
     * @uses CBulkCustomsClearanceLineItem::setCountryOfOrigin()
     * @uses CBulkCustomsClearanceLineItem::setValueInInvoiceCurrency()
     * @uses CBulkCustomsClearanceLineItem::setGrossWeight()
     * @uses CBulkCustomsClearanceLineItem::setNetWeight()
     * @uses CBulkCustomsClearanceLineItem::setPreferentialTrade()
     * @uses CBulkCustomsClearanceLineItem::setStatisticalValue()
     * @uses CBulkCustomsClearanceLineItem::setStatisticalQuantity()
     * @uses CBulkCustomsClearanceLineItem::setNationalCustomsFields()
     * @param \GlsPoland\StructType\CQuantityExt $quantity
     * @param string $commodityCode
     * @param string $goodsDescription
     * @param string $countryOfOrigin
     * @param float $valueInInvoiceCurrency
     * @param \GlsPoland\StructType\CWeightExt $grossWeight
     * @param \GlsPoland\StructType\CWeightExt $netWeight
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade
     * @param \GlsPoland\StructType\CAmountOfMoney $statisticalValue
     * @param float $statisticalQuantity
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields
     */
    public function __construct(\GlsPoland\StructType\CQuantityExt $quantity = null, $commodityCode = null, $goodsDescription = null, $countryOfOrigin = null, $valueInInvoiceCurrency = null, \GlsPoland\StructType\CWeightExt $grossWeight = null, \GlsPoland\StructType\CWeightExt $netWeight = null, \GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade = null, \GlsPoland\StructType\CAmountOfMoney $statisticalValue = null, $statisticalQuantity = null, \GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields = null)
    {
        $this
            ->setQuantity($quantity)
            ->setCommodityCode($commodityCode)
            ->setGoodsDescription($goodsDescription)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setValueInInvoiceCurrency($valueInInvoiceCurrency)
            ->setGrossWeight($grossWeight)
            ->setNetWeight($netWeight)
            ->setPreferentialTrade($preferentialTrade)
            ->setStatisticalValue($statisticalValue)
            ->setStatisticalQuantity($statisticalQuantity)
            ->setNationalCustomsFields($nationalCustomsFields);
    }
    /**
     * Get quantity value
     * @return \GlsPoland\StructType\CQuantityExt
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param \GlsPoland\StructType\CQuantityExt $quantity
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setQuantity(\GlsPoland\StructType\CQuantityExt $quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get commodityCode value
     * @return string
     */
    public function getCommodityCode()
    {
        return $this->commodityCode;
    }
    /**
     * Set commodityCode value
     * @param string $commodityCode
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->commodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get goodsDescription value
     * @return string
     */
    public function getGoodsDescription()
    {
        return $this->goodsDescription;
    }
    /**
     * Set goodsDescription value
     * @param string $goodsDescription
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setGoodsDescription($goodsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($goodsDescription) && !is_string($goodsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsDescription, true), gettype($goodsDescription)), __LINE__);
        }
        $this->goodsDescription = $goodsDescription;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get valueInInvoiceCurrency value
     * @return float
     */
    public function getValueInInvoiceCurrency()
    {
        return $this->valueInInvoiceCurrency;
    }
    /**
     * Set valueInInvoiceCurrency value
     * @param float $valueInInvoiceCurrency
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setValueInInvoiceCurrency($valueInInvoiceCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($valueInInvoiceCurrency) && !(is_float($valueInInvoiceCurrency) || is_numeric($valueInInvoiceCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valueInInvoiceCurrency, true), gettype($valueInInvoiceCurrency)), __LINE__);
        }
        $this->valueInInvoiceCurrency = $valueInInvoiceCurrency;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return \GlsPoland\StructType\CWeightExt
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param \GlsPoland\StructType\CWeightExt $grossWeight
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setGrossWeight(\GlsPoland\StructType\CWeightExt $grossWeight = null)
    {
        $this->grossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get netWeight value
     * @return \GlsPoland\StructType\CWeightExt
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param \GlsPoland\StructType\CWeightExt $netWeight
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setNetWeight(\GlsPoland\StructType\CWeightExt $netWeight = null)
    {
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get preferentialTrade value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade|null
     */
    public function getPreferentialTrade()
    {
        return $this->preferentialTrade;
    }
    /**
     * Set preferentialTrade value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setPreferentialTrade(\GlsPoland\StructType\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade = null)
    {
        $this->preferentialTrade = $preferentialTrade;
        return $this;
    }
    /**
     * Get statisticalValue value
     * @return \GlsPoland\StructType\CAmountOfMoney|null
     */
    public function getStatisticalValue()
    {
        return $this->statisticalValue;
    }
    /**
     * Set statisticalValue value
     * @param \GlsPoland\StructType\CAmountOfMoney $statisticalValue
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setStatisticalValue(\GlsPoland\StructType\CAmountOfMoney $statisticalValue = null)
    {
        $this->statisticalValue = $statisticalValue;
        return $this;
    }
    /**
     * Get statisticalQuantity value
     * @return float|null
     */
    public function getStatisticalQuantity()
    {
        return $this->statisticalQuantity;
    }
    /**
     * Set statisticalQuantity value
     * @param float $statisticalQuantity
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setStatisticalQuantity($statisticalQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($statisticalQuantity) && !(is_float($statisticalQuantity) || is_numeric($statisticalQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($statisticalQuantity, true), gettype($statisticalQuantity)), __LINE__);
        }
        $this->statisticalQuantity = $statisticalQuantity;
        return $this;
    }
    /**
     * Get nationalCustomsFields value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields|null
     */
    public function getNationalCustomsFields()
    {
        return $this->nationalCustomsFields;
    }
    /**
     * Set nationalCustomsFields value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function setNationalCustomsFields(\GlsPoland\StructType\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields = null)
    {
        $this->nationalCustomsFields = $nationalCustomsFields;
        return $this;
    }
}
