<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearanceExporter StructType
 * @subpackage Structs
 */
class CBulkCustomsClearanceExporter extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceAddress
     */
    public $address;
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceContactPerson
     */
    public $contactPerson;
    /**
     * The isCommercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isCommercial;
    /**
     * The eoriNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eoriNumber;
    /**
     * The swissUid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $swissUid;
    /**
     * The taxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $taxId;
    /**
     * The vatRegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vatRegistrationNumber;
    /**
     * The authorizationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorizationNumber;
    /**
     * The loadingPlaceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loadingPlaceCode;
    /**
     * Constructor method for cBulkCustomsClearanceExporter
     * @uses CBulkCustomsClearanceExporter::setAddress()
     * @uses CBulkCustomsClearanceExporter::setContactPerson()
     * @uses CBulkCustomsClearanceExporter::setIsCommercial()
     * @uses CBulkCustomsClearanceExporter::setEoriNumber()
     * @uses CBulkCustomsClearanceExporter::setSwissUid()
     * @uses CBulkCustomsClearanceExporter::setTaxId()
     * @uses CBulkCustomsClearanceExporter::setVatRegistrationNumber()
     * @uses CBulkCustomsClearanceExporter::setAuthorizationNumber()
     * @uses CBulkCustomsClearanceExporter::setLoadingPlaceCode()
     * @param \GlsPoland\StructType\CBulkCustomsClearanceAddress $address
     * @param \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson
     * @param bool $isCommercial
     * @param string $eoriNumber
     * @param string $swissUid
     * @param string $taxId
     * @param string $vatRegistrationNumber
     * @param string $authorizationNumber
     * @param string $loadingPlaceCode
     */
    public function __construct(\GlsPoland\StructType\CBulkCustomsClearanceAddress $address = null, \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson = null, $isCommercial = null, $eoriNumber = null, $swissUid = null, $taxId = null, $vatRegistrationNumber = null, $authorizationNumber = null, $loadingPlaceCode = null)
    {
        $this
            ->setAddress($address)
            ->setContactPerson($contactPerson)
            ->setIsCommercial($isCommercial)
            ->setEoriNumber($eoriNumber)
            ->setSwissUid($swissUid)
            ->setTaxId($taxId)
            ->setVatRegistrationNumber($vatRegistrationNumber)
            ->setAuthorizationNumber($authorizationNumber)
            ->setLoadingPlaceCode($loadingPlaceCode);
    }
    /**
     * Get address value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceAddress
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceAddress $address
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setAddress(\GlsPoland\StructType\CBulkCustomsClearanceAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get contactPerson value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceContactPerson
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param \GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setContactPerson(\GlsPoland\StructType\CBulkCustomsClearanceContactPerson $contactPerson = null)
    {
        $this->contactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get isCommercial value
     * @return bool
     */
    public function getIsCommercial()
    {
        return $this->isCommercial;
    }
    /**
     * Set isCommercial value
     * @param bool $isCommercial
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setIsCommercial($isCommercial = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommercial) && !is_bool($isCommercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommercial, true), gettype($isCommercial)), __LINE__);
        }
        $this->isCommercial = $isCommercial;
        return $this;
    }
    /**
     * Get eoriNumber value
     * @return string|null
     */
    public function getEoriNumber()
    {
        return $this->eoriNumber;
    }
    /**
     * Set eoriNumber value
     * @param string $eoriNumber
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setEoriNumber($eoriNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eoriNumber) && !is_string($eoriNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eoriNumber, true), gettype($eoriNumber)), __LINE__);
        }
        $this->eoriNumber = $eoriNumber;
        return $this;
    }
    /**
     * Get swissUid value
     * @return string|null
     */
    public function getSwissUid()
    {
        return $this->swissUid;
    }
    /**
     * Set swissUid value
     * @param string $swissUid
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setSwissUid($swissUid = null)
    {
        // validation for constraint: string
        if (!is_null($swissUid) && !is_string($swissUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swissUid, true), gettype($swissUid)), __LINE__);
        }
        $this->swissUid = $swissUid;
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->taxId;
    }
    /**
     * Set taxId value
     * @param string $taxId
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->taxId = $taxId;
        return $this;
    }
    /**
     * Get vatRegistrationNumber value
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return $this->vatRegistrationNumber;
    }
    /**
     * Set vatRegistrationNumber value
     * @param string $vatRegistrationNumber
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        $this->vatRegistrationNumber = $vatRegistrationNumber;
        return $this;
    }
    /**
     * Get authorizationNumber value
     * @return string|null
     */
    public function getAuthorizationNumber()
    {
        return $this->authorizationNumber;
    }
    /**
     * Set authorizationNumber value
     * @param string $authorizationNumber
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setAuthorizationNumber($authorizationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationNumber) && !is_string($authorizationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationNumber, true), gettype($authorizationNumber)), __LINE__);
        }
        $this->authorizationNumber = $authorizationNumber;
        return $this;
    }
    /**
     * Get loadingPlaceCode value
     * @return string|null
     */
    public function getLoadingPlaceCode()
    {
        return $this->loadingPlaceCode;
    }
    /**
     * Set loadingPlaceCode value
     * @param string $loadingPlaceCode
     * @return \GlsPoland\StructType\CBulkCustomsClearanceExporter
     */
    public function setLoadingPlaceCode($loadingPlaceCode = null)
    {
        // validation for constraint: string
        if (!is_null($loadingPlaceCode) && !is_string($loadingPlaceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingPlaceCode, true), gettype($loadingPlaceCode)), __LINE__);
        }
        $this->loadingPlaceCode = $loadingPlaceCode;
        return $this;
    }
}
