<?php

namespace GlsPoland\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adeOption_Set StructType
 * Meta information extracted from the WSDL
 * - type: tns:adeOption_Set
 * @subpackage Structs
 */
class AdeOption_Set extends AbstractStructBase
{
    /**
     * The session
     * @var string
     */
    public $session;
    /**
     * The option
     * @var string
     */
    public $option;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for adeOption_Set
     * @uses AdeOption_Set::setSession()
     * @uses AdeOption_Set::setOption()
     * @uses AdeOption_Set::setValue()
     * @param string $session
     * @param string $option
     * @param string $value
     */
    public function __construct($session = null, $option = null, $value = null)
    {
        $this
            ->setSession($session)
            ->setOption($option)
            ->setValue($value);
    }
    /**
     * Get session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param string $session
     * @return \GlsPoland\StructType\AdeOption_Set
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @param string $option
     * @return \GlsPoland\StructType\AdeOption_Set
     */
    public function setOption($option = null)
    {
        // validation for constraint: string
        if (!is_null($option) && !is_string($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option, true), gettype($option)), __LINE__);
        }
        $this->option = $option;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \GlsPoland\StructType\AdeOption_Set
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
