<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zip ServiceType
 * @subpackage Services
 */
class Zip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeParcelShop_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by zip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop_SearchByZip $parameters
     * @return \GlsPoland\StructType\AdeParcelShop_SearchByZipResponse|bool
     */
    public function adeParcelShop_SearchByZip(\GlsPoland\StructType\AdeParcelShop_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop2_SearchByZip $parameters
     * @return \GlsPoland\StructType\AdeParcelShop2_SearchByZipResponse|bool
     */
    public function adeParcelShop2_SearchByZip(\GlsPoland\StructType\AdeParcelShop2_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop3_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 3)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeParcelShop3_SearchByZip $parameters
     * @return \GlsPoland\StructType\AdeParcelShop3_SearchByZipResponse|bool
     */
    public function adeParcelShop3_SearchByZip(\GlsPoland\StructType\AdeParcelShop3_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop3_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeParcelShop2_SearchByZipResponse|\GlsPoland\StructType\AdeParcelShop3_SearchByZipResponse|\GlsPoland\StructType\AdeParcelShop_SearchByZipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
