<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePfc_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePfc_GetStatus $parameters
     * @return \GlsPoland\StructType\AdePfc_GetStatusResponse|bool
     */
    public function adePfc_GetStatus(\GlsPoland\StructType\AdePfc_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeSendAddr_GetStatus $parameters
     * @return \GlsPoland\StructType\AdeSendAddr_GetStatusResponse|bool
     */
    public function adeSendAddr_GetStatus(\GlsPoland\StructType\AdeSendAddr_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePfc_GetStatusResponse|\GlsPoland\StructType\AdeSendAddr_GetStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
