<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parcel ServiceType
 * @subpackage Services
 */
class Parcel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_DeleteParcel
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box based on number of parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_DeleteParcel $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_DeleteParcelResponse|bool
     */
    public function adePreparingBox_DeleteParcel(\GlsPoland\StructType\AdePreparingBox_DeleteParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePreparingBox_DeleteParcelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
