<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Integrator ServiceType
 * @subpackage Services
 */
class Integrator extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLoginIntegrator
     * Meta information extracted from the WSDL
     * - documentation: Login integrator to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLoginIntegrator $parameters
     * @return \GlsPoland\StructType\AdeLoginIntegratorResponse|bool
     */
    public function adeLoginIntegrator(\GlsPoland\StructType\AdeLoginIntegrator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginIntegrator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLoginIntegratorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
