<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ident ServiceType
 * @subpackage Services
 */
class Ident extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_GetIdent
     * Meta information extracted from the WSDL
     * - documentation: Get ident document from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetIdent $parameters
     * @return \GlsPoland\StructType\AdePickup_GetIdentResponse|bool
     */
    public function adePickup_GetIdent(\GlsPoland\StructType\AdePickup_GetIdent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIdent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetIdentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
