<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Document ServiceType
 * @subpackage Services
 */
class Document extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * adeBulkCustomsClearance_UploadDocument
     * Meta information extracted from the WSDL
     * - documentation: Create customs declaration for list of parcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeBulkCustomsClearance_UploadDocument $parameters
     * @return \GlsPoland\StructType\AdeBulkCustomsClearance_UploadDocumentResponse|bool
     */
    public function adeBulkCustomsClearance_UploadDocument(\GlsPoland\StructType\AdeBulkCustomsClearance_UploadDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeBulkCustomsClearance_UploadDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeBulkCustomsClearance_UploadDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
