<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ade-test.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ade-test.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GlsPoland\ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \GlsPoland\ServiceType\Login($options);
/**
 * Sample call for adeLogin operation/method
 */
if ($login->adeLogin(new \GlsPoland\StructType\AdeLogin()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Integrator ServiceType
 */
$integrator = new \GlsPoland\ServiceType\Integrator($options);
/**
 * Sample call for adeLoginIntegrator operation/method
 */
if ($integrator->adeLoginIntegrator(new \GlsPoland\StructType\AdeLoginIntegrator()) !== false) {
    print_r($integrator->getResult());
} else {
    print_r($integrator->getLastError());
}
/**
 * Samples for Code ServiceType
 */
$code = new \GlsPoland\ServiceType\Code($options);
/**
 * Sample call for adeLoginByLocalizationCode operation/method
 */
if ($code->adeLoginByLocalizationCode(new \GlsPoland\StructType\AdeLoginByLocalizationCode()) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \GlsPoland\ServiceType\Logout($options);
/**
 * Sample call for adeLogout operation/method
 */
if ($logout->adeLogout(new \GlsPoland\StructType\AdeLogout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \GlsPoland\ServiceType\Insert($options);
/**
 * Sample call for adePreparingBox_Insert operation/method
 */
if ($insert->adePreparingBox_Insert(new \GlsPoland\StructType\AdePreparingBox_Insert()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Ext ServiceType
 */
$ext = new \GlsPoland\ServiceType\Ext($options);
/**
 * Sample call for adePreparingBox_InsertExt operation/method
 */
if ($ext->adePreparingBox_InsertExt(new \GlsPoland\StructType\AdePreparingBox_InsertExt()) !== false) {
    print_r($ext->getResult());
} else {
    print_r($ext->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignLabelsExt operation/method
 */
if ($ext->adePreparingBox_GetConsignLabelsExt(new \GlsPoland\StructType\AdePreparingBox_GetConsignLabelsExt()) !== false) {
    print_r($ext->getResult());
} else {
    print_r($ext->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabelsExt operation/method
 */
if ($ext->adePickup_GetConsignLabelsExt(new \GlsPoland\StructType\AdePickup_GetConsignLabelsExt()) !== false) {
    print_r($ext->getResult());
} else {
    print_r($ext->getLastError());
}
/**
 * Samples for Ds ServiceType
 */
$ds = new \GlsPoland\ServiceType\Ds($options);
/**
 * Sample call for adePreparingBox_GetConsignIDs operation/method
 */
if ($ds->adePreparingBox_GetConsignIDs(new \GlsPoland\StructType\AdePreparingBox_GetConsignIDs()) !== false) {
    print_r($ds->getResult());
} else {
    print_r($ds->getLastError());
}
/**
 * Sample call for adePickup_GetIDs operation/method
 */
if ($ds->adePickup_GetIDs(new \GlsPoland\StructType\AdePickup_GetIDs()) !== false) {
    print_r($ds->getResult());
} else {
    print_r($ds->getLastError());
}
/**
 * Sample call for adePickup_GetConsignIDs operation/method
 */
if ($ds->adePickup_GetConsignIDs(new \GlsPoland\StructType\AdePickup_GetConsignIDs()) !== false) {
    print_r($ds->getResult());
} else {
    print_r($ds->getLastError());
}
/**
 * Sample call for adeProfile_GetIDs operation/method
 */
if ($ds->adeProfile_GetIDs(new \GlsPoland\StructType\AdeProfile_GetIDs()) !== false) {
    print_r($ds->getResult());
} else {
    print_r($ds->getLastError());
}
/**
 * Sample call for adePickup_GetConsignPODs operation/method
 */
if ($ds->adePickup_GetConsignPODs(new \GlsPoland\StructType\AdePickup_GetConsignPODs()) !== false) {
    print_r($ds->getResult());
} else {
    print_r($ds->getLastError());
}
/**
 * Samples for Consign ServiceType
 */
$consign = new \GlsPoland\ServiceType\Consign($options);
/**
 * Sample call for adePreparingBox_DeleteConsign operation/method
 */
if ($consign->adePreparingBox_DeleteConsign(new \GlsPoland\StructType\AdePreparingBox_DeleteConsign()) !== false) {
    print_r($consign->getResult());
} else {
    print_r($consign->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsign operation/method
 */
if ($consign->adePreparingBox_GetConsign(new \GlsPoland\StructType\AdePreparingBox_GetConsign()) !== false) {
    print_r($consign->getResult());
} else {
    print_r($consign->getLastError());
}
/**
 * Sample call for adePickup_GetConsign operation/method
 */
if ($consign->adePickup_GetConsign(new \GlsPoland\StructType\AdePickup_GetConsign()) !== false) {
    print_r($consign->getResult());
} else {
    print_r($consign->getLastError());
}
/**
 * Samples for Labels ServiceType
 */
$labels = new \GlsPoland\ServiceType\Labels($options);
/**
 * Sample call for adePreparingBox_GetConsignLabels operation/method
 */
if ($labels->adePreparingBox_GetConsignLabels(new \GlsPoland\StructType\AdePreparingBox_GetConsignLabels()) !== false) {
    print_r($labels->getResult());
} else {
    print_r($labels->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignsLabels operation/method
 */
if ($labels->adePreparingBox_GetConsignsLabels(new \GlsPoland\StructType\AdePreparingBox_GetConsignsLabels()) !== false) {
    print_r($labels->getResult());
} else {
    print_r($labels->getLastError());
}
/**
 * Sample call for adePickup_GetLabels operation/method
 */
if ($labels->adePickup_GetLabels(new \GlsPoland\StructType\AdePickup_GetLabels()) !== false) {
    print_r($labels->getResult());
} else {
    print_r($labels->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabels operation/method
 */
if ($labels->adePickup_GetConsignLabels(new \GlsPoland\StructType\AdePickup_GetConsignLabels()) !== false) {
    print_r($labels->getResult());
} else {
    print_r($labels->getLastError());
}
/**
 * Sample call for adePickup_GetParcelsLabels operation/method
 */
if ($labels->adePickup_GetParcelsLabels(new \GlsPoland\StructType\AdePickup_GetParcelsLabels()) !== false) {
    print_r($labels->getResult());
} else {
    print_r($labels->getLastError());
}
/**
 * Samples for Docs ServiceType
 */
$docs = new \GlsPoland\ServiceType\Docs($options);
/**
 * Sample call for adePreparingBox_GetConsignDocs operation/method
 */
if ($docs->adePreparingBox_GetConsignDocs(new \GlsPoland\StructType\AdePreparingBox_GetConsignDocs()) !== false) {
    print_r($docs->getResult());
} else {
    print_r($docs->getLastError());
}
/**
 * Samples for Label ServiceType
 */
$label = new \GlsPoland\ServiceType\Label($options);
/**
 * Sample call for adePreparingBox_GetParcelLabel operation/method
 */
if ($label->adePreparingBox_GetParcelLabel(new \GlsPoland\StructType\AdePreparingBox_GetParcelLabel()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Sample call for adePickup_GetParcelLabel operation/method
 */
if ($label->adePickup_GetParcelLabel(new \GlsPoland\StructType\AdePickup_GetParcelLabel()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \GlsPoland\ServiceType\Create($options);
/**
 * Sample call for adePickup_Create operation/method
 */
if ($create->adePickup_Create(new \GlsPoland\StructType\AdePickup_Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for adeBulkCustomsClearance_Create operation/method
 */
if ($create->adeBulkCustomsClearance_Create(new \GlsPoland\StructType\AdeBulkCustomsClearance_Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \GlsPoland\ServiceType\Get($options);
/**
 * Sample call for adePickup_Get operation/method
 */
if ($get->adePickup_Get(new \GlsPoland\StructType\AdePickup_Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for adeTrackID_Get operation/method
 */
if ($get->adeTrackID_Get(new \GlsPoland\StructType\AdeTrackID_Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for adeOption_Get operation/method
 */
if ($get->adeOption_Get(new \GlsPoland\StructType\AdeOption_Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for adePOD_Get operation/method
 */
if ($get->adePOD_Get(new \GlsPoland\StructType\AdePOD_Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Binds ServiceType
 */
$binds = new \GlsPoland\ServiceType\Binds($options);
/**
 * Sample call for adePickup_GetConsignBinds operation/method
 */
if ($binds->adePickup_GetConsignBinds(new \GlsPoland\StructType\AdePickup_GetConsignBinds()) !== false) {
    print_r($binds->getResult());
} else {
    print_r($binds->getLastError());
}
/**
 * Samples for Receipt ServiceType
 */
$receipt = new \GlsPoland\ServiceType\Receipt($options);
/**
 * Sample call for adePickup_GetReceipt operation/method
 */
if ($receipt->adePickup_GetReceipt(new \GlsPoland\StructType\AdePickup_GetReceipt()) !== false) {
    print_r($receipt->getResult());
} else {
    print_r($receipt->getLastError());
}
/**
 * Samples for Ident ServiceType
 */
$ident = new \GlsPoland\ServiceType\Ident($options);
/**
 * Sample call for adePickup_GetIdent operation/method
 */
if ($ident->adePickup_GetIdent(new \GlsPoland\StructType\AdePickup_GetIdent()) !== false) {
    print_r($ident->getResult());
} else {
    print_r($ident->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \GlsPoland\ServiceType\Search($options);
/**
 * Sample call for adePickup_ParcelNumberSearch operation/method
 */
if ($search->adePickup_ParcelNumberSearch(new \GlsPoland\StructType\AdePickup_ParcelNumberSearch()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Number ServiceType
 */
$number = new \GlsPoland\ServiceType\Number($options);
/**
 * Sample call for adePartner_GetParcelNumber operation/method
 */
if ($number->adePartner_GetParcelNumber(new \GlsPoland\StructType\AdePartner_GetParcelNumber()) !== false) {
    print_r($number->getResult());
} else {
    print_r($number->getLastError());
}
/**
 * Samples for Active ServiceType
 */
$active = new \GlsPoland\ServiceType\Active($options);
/**
 * Sample call for adeProfile_GetActive operation/method
 */
if ($active->adeProfile_GetActive(new \GlsPoland\StructType\AdeProfile_GetActive()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
/**
 * Sample call for adeLang_GetActive operation/method
 */
if ($active->adeLang_GetActive(new \GlsPoland\StructType\AdeLang_GetActive()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \GlsPoland\ServiceType\Change($options);
/**
 * Sample call for adeProfile_Change operation/method
 */
if ($change->adeProfile_Change(new \GlsPoland\StructType\AdeProfile_Change()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for adeLang_Change operation/method
 */
if ($change->adeLang_Change(new \GlsPoland\StructType\AdeLang_Change()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \GlsPoland\ServiceType\Status($options);
/**
 * Sample call for adePfc_GetStatus operation/method
 */
if ($status->adePfc_GetStatus(new \GlsPoland\StructType\AdePfc_GetStatus()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Sample call for adeSendAddr_GetStatus operation/method
 */
if ($status->adeSendAddr_GetStatus(new \GlsPoland\StructType\AdeSendAddr_GetStatus()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Dictionary ServiceType
 */
$dictionary = new \GlsPoland\ServiceType\Dictionary($options);
/**
 * Sample call for adePfc_GetDictionary operation/method
 */
if ($dictionary->adePfc_GetDictionary(new \GlsPoland\StructType\AdePfc_GetDictionary()) !== false) {
    print_r($dictionary->getResult());
} else {
    print_r($dictionary->getLastError());
}
/**
 * Sample call for adeSendAddr_GetDictionary operation/method
 */
if ($dictionary->adeSendAddr_GetDictionary(new \GlsPoland\StructType\AdeSendAddr_GetDictionary()) !== false) {
    print_r($dictionary->getResult());
} else {
    print_r($dictionary->getLastError());
}
/**
 * Samples for Allowed ServiceType
 */
$allowed = new \GlsPoland\ServiceType\Allowed($options);
/**
 * Sample call for adeServices_GetAllowed operation/method
 */
if ($allowed->adeServices_GetAllowed(new \GlsPoland\StructType\AdeServices_GetAllowed()) !== false) {
    print_r($allowed->getResult());
} else {
    print_r($allowed->getLastError());
}
/**
 * Samples for COD ServiceType
 */
$cOD = new \GlsPoland\ServiceType\COD($options);
/**
 * Sample call for adeServices_GetMaxCOD operation/method
 */
if ($cOD->adeServices_GetMaxCOD(new \GlsPoland\StructType\AdeServices_GetMaxCOD()) !== false) {
    print_r($cOD->getResult());
} else {
    print_r($cOD->getLastError());
}
/**
 * Samples for Weights ServiceType
 */
$weights = new \GlsPoland\ServiceType\Weights($options);
/**
 * Sample call for adeServices_GetMaxParcelWeights operation/method
 */
if ($weights->adeServices_GetMaxParcelWeights(new \GlsPoland\StructType\AdeServices_GetMaxParcelWeights()) !== false) {
    print_r($weights->getResult());
} else {
    print_r($weights->getLastError());
}
/**
 * Samples for Guaranteed ServiceType
 */
$guaranteed = new \GlsPoland\ServiceType\Guaranteed($options);
/**
 * Sample call for adeServices_GetGuaranteed operation/method
 */
if ($guaranteed->adeServices_GetGuaranteed(new \GlsPoland\StructType\AdeServices_GetGuaranteed()) !== false) {
    print_r($guaranteed->getResult());
} else {
    print_r($guaranteed->getLastError());
}
/**
 * Samples for SDS ServiceType
 */
$sDS = new \GlsPoland\ServiceType\SDS($options);
/**
 * Sample call for adeServices_GetCountriesSDS operation/method
 */
if ($sDS->adeServices_GetCountriesSDS(new \GlsPoland\StructType\AdeServices_GetCountriesSDS()) !== false) {
    print_r($sDS->getResult());
} else {
    print_r($sDS->getLastError());
}
/**
 * Samples for SRS ServiceType
 */
$sRS = new \GlsPoland\ServiceType\SRS($options);
/**
 * Sample call for adeServices_GetCountriesSRS operation/method
 */
if ($sRS->adeServices_GetCountriesSRS(new \GlsPoland\StructType\AdeServices_GetCountriesSRS()) !== false) {
    print_r($sRS->getResult());
} else {
    print_r($sRS->getLastError());
}
/**
 * Samples for CDX ServiceType
 */
$cDX = new \GlsPoland\ServiceType\CDX($options);
/**
 * Sample call for adeServices_GetCountriesCDX operation/method
 */
if ($cDX->adeServices_GetCountriesCDX(new \GlsPoland\StructType\AdeServices_GetCountriesCDX()) !== false) {
    print_r($cDX->getResult());
} else {
    print_r($cDX->getLastError());
}
/**
 * Samples for City ServiceType
 */
$city = new \GlsPoland\ServiceType\City($options);
/**
 * Sample call for adeZip_GetCity operation/method
 */
if ($city->adeZip_GetCity(new \GlsPoland\StructType\AdeZip_GetCity()) !== false) {
    print_r($city->getResult());
} else {
    print_r($city->getLastError());
}
/**
 * Samples for Required ServiceType
 */
$required = new \GlsPoland\ServiceType\Required($options);
/**
 * Sample call for adeZip_CustomsRequired operation/method
 */
if ($required->adeZip_CustomsRequired(new \GlsPoland\StructType\AdeZip_CustomsRequired()) !== false) {
    print_r($required->getResult());
} else {
    print_r($required->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \GlsPoland\ServiceType\Set($options);
/**
 * Sample call for adeOption_Set operation/method
 */
if ($set->adeOption_Set(new \GlsPoland\StructType\AdeOption_Set()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Zip ServiceType
 */
$zip = new \GlsPoland\ServiceType\Zip($options);
/**
 * Sample call for adeParcelShop_SearchByZip operation/method
 */
if ($zip->adeParcelShop_SearchByZip(new \GlsPoland\StructType\AdeParcelShop_SearchByZip()) !== false) {
    print_r($zip->getResult());
} else {
    print_r($zip->getLastError());
}
/**
 * Sample call for adeParcelShop2_SearchByZip operation/method
 */
if ($zip->adeParcelShop2_SearchByZip(new \GlsPoland\StructType\AdeParcelShop2_SearchByZip()) !== false) {
    print_r($zip->getResult());
} else {
    print_r($zip->getLastError());
}
/**
 * Sample call for adeParcelShop3_SearchByZip operation/method
 */
if ($zip->adeParcelShop3_SearchByZip(new \GlsPoland\StructType\AdeParcelShop3_SearchByZip()) !== false) {
    print_r($zip->getResult());
} else {
    print_r($zip->getLastError());
}
/**
 * Samples for ID ServiceType
 */
$iD = new \GlsPoland\ServiceType\ID($options);
/**
 * Sample call for adeParcelShop_SearchByID operation/method
 */
if ($iD->adeParcelShop_SearchByID(new \GlsPoland\StructType\AdeParcelShop_SearchByID()) !== false) {
    print_r($iD->getResult());
} else {
    print_r($iD->getLastError());
}
/**
 * Samples for Country ServiceType
 */
$country = new \GlsPoland\ServiceType\Country($options);
/**
 * Sample call for adeParcelShop_GetByCountry operation/method
 */
if ($country->adeParcelShop_GetByCountry(new \GlsPoland\StructType\AdeParcelShop_GetByCountry()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for adeParcelShop2_GetByCountry operation/method
 */
if ($country->adeParcelShop2_GetByCountry(new \GlsPoland\StructType\AdeParcelShop2_GetByCountry()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Sample call for adeParcelShop3_GetByCountry operation/method
 */
if ($country->adeParcelShop3_GetByCountry(new \GlsPoland\StructType\AdeParcelShop3_GetByCountry()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Samples for Dec ServiceType
 */
$dec = new \GlsPoland\ServiceType\Dec($options);
/**
 * Sample call for adePreparingBox_GetConsignCustomsDec operation/method
 */
if ($dec->adePreparingBox_GetConsignCustomsDec(new \GlsPoland\StructType\AdePreparingBox_GetConsignCustomsDec()) !== false) {
    print_r($dec->getResult());
} else {
    print_r($dec->getLastError());
}
/**
 * Sample call for adePickup_GetConsignCustomsDec operation/method
 */
if ($dec->adePickup_GetConsignCustomsDec(new \GlsPoland\StructType\AdePickup_GetConsignCustomsDec()) !== false) {
    print_r($dec->getResult());
} else {
    print_r($dec->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \GlsPoland\ServiceType\Order($options);
/**
 * Sample call for adeCourier_Order operation/method
 */
if ($order->adeCourier_Order(new \GlsPoland\StructType\AdeCourier_Order()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Document ServiceType
 */
$document = new \GlsPoland\ServiceType\Document($options);
/**
 * Sample call for adeBulkCustomsClearance_UploadDocument operation/method
 */
if ($document->adeBulkCustomsClearance_UploadDocument(new \GlsPoland\StructType\AdeBulkCustomsClearance_UploadDocument()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
