<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consign ServiceType
 * @subpackage Services
 */
class Consign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_DeleteConsign
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_DeleteConsign $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_DeleteConsignResponse|bool
     */
    public function adePreparingBox_DeleteConsign(\GlsPoland\StructType\AdePreparingBox_DeleteConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsign $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignResponse|bool
     */
    public function adePreparingBox_GetConsign(\GlsPoland\StructType\AdePreparingBox_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsign $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignResponse|bool
     */
    public function adePickup_GetConsign(\GlsPoland\StructType\AdePickup_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignResponse|\GlsPoland\StructType\AdePreparingBox_DeleteConsignResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
