<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Code ServiceType
 * @subpackage Services
 */
class Code extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLoginByLocalizationCode
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus by Localization Code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLoginByLocalizationCode $parameters
     * @return \GlsPoland\StructType\AdeLoginByLocalizationCodeResponse|bool
     */
    public function adeLoginByLocalizationCode(\GlsPoland\StructType\AdeLoginByLocalizationCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginByLocalizationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLoginByLocalizationCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
