<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Binds ServiceType
 * @subpackage Services
 */
class Binds extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_GetConsignBinds
     * Meta information extracted from the WSDL
     * - documentation: List of shipment IDs with their associated/bind shipment IDs from preparing box for a single shipment confirmation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignBinds $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignBindsResponse|bool
     */
    public function adePickup_GetConsignBinds(\GlsPoland\StructType\AdePickup_GetConsignBinds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignBinds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignBindsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
