<?php

namespace GlsPoland\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cBulkCustomsClearanceLineItemsArray ArrayType
 * @subpackage Arrays
 */
class CBulkCustomsClearanceLineItemsArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 1
     * @var \GlsPoland\StructType\CBulkCustomsClearanceLineItem[]
     */
    public $items;
    /**
     * Constructor method for cBulkCustomsClearanceLineItemsArray
     * @uses CBulkCustomsClearanceLineItemsArray::setItems()
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItem[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cBulkCustomsClearanceLineItemsArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cBulkCustomsClearanceLineItemsArrayItemsItem instanceof \GlsPoland\StructType\CBulkCustomsClearanceLineItem) {
                $invalidValues[] = is_object($cBulkCustomsClearanceLineItemsArrayItemsItem) ? get_class($cBulkCustomsClearanceLineItemsArrayItemsItem) : sprintf('%s(%s)', gettype($cBulkCustomsClearanceLineItemsArrayItemsItem), var_export($cBulkCustomsClearanceLineItemsArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GlsPoland\StructType\CBulkCustomsClearanceLineItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItem[] $items
     * @return \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($items) && count($items) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($items)), __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GlsPoland\StructType\CBulkCustomsClearanceLineItem $item
     * @return \GlsPoland\ArrayType\CBulkCustomsClearanceLineItemsArray
     */
    public function addToItems(\GlsPoland\StructType\CBulkCustomsClearanceLineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsPoland\StructType\CBulkCustomsClearanceLineItem) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GlsPoland\StructType\CBulkCustomsClearanceLineItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->items) && count($this->items) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->items)), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GlsPoland\StructType\CBulkCustomsClearanceLineItem
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
