<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SDS ServiceType
 * @subpackage Services
 */
class SDS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetCountriesSDS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SDS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetCountriesSDS $parameters
     * @return \GlsPoland\StructType\AdeServices_GetCountriesSDSResponse|bool
     */
    public function adeServices_GetCountriesSDS(\GlsPoland\StructType\AdeServices_GetCountriesSDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetCountriesSDSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
