<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeOption_Set
     * Meta information extracted from the WSDL
     * - documentation: Set system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeOption_Set $parameters
     * @return \GlsPoland\StructType\AdeOption_SetResponse|bool
     */
    public function adeOption_Set(\GlsPoland\StructType\AdeOption_Set $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Set($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeOption_SetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
