<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receipt ServiceType
 * @subpackage Services
 */
class Receipt extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePickup_GetReceipt
     * Meta information extracted from the WSDL
     * - documentation: Get receipt from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetReceipt $parameters
     * @return \GlsPoland\StructType\AdePickup_GetReceiptResponse|bool
     */
    public function adePickup_GetReceipt(\GlsPoland\StructType\AdePickup_GetReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
