<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for City ServiceType
 * @subpackage Services
 */
class City extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeZip_GetCity
     * Meta information extracted from the WSDL
     * - documentation: Search for city.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeZip_GetCity $parameters
     * @return \GlsPoland\StructType\AdeZip_GetCityResponse|bool
     */
    public function adeZip_GetCity(\GlsPoland\StructType\AdeZip_GetCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_GetCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeZip_GetCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
