<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLogin
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeLogin $parameters
     * @return \GlsPoland\StructType\AdeLoginResponse|bool
     */
    public function adeLogin(\GlsPoland\StructType\AdeLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
