<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Guaranteed ServiceType
 * @subpackage Services
 */
class Guaranteed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeServices_GetGuaranteed
     * Meta information extracted from the WSDL
     * - documentation: Get guaranteed services for given zip code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeServices_GetGuaranteed $parameters
     * @return \GlsPoland\StructType\AdeServices_GetGuaranteedResponse|bool
     */
    public function adeServices_GetGuaranteed(\GlsPoland\StructType\AdeServices_GetGuaranteed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetGuaranteed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdeServices_GetGuaranteedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
