<?php

namespace GlsPoland\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ds ServiceType
 * @subpackage Services
 */
class Ds extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePreparingBox_GetConsignIDs $parameters
     * @return \GlsPoland\StructType\AdePreparingBox_GetConsignIDsResponse|bool
     */
    public function adePreparingBox_GetConsignIDs(\GlsPoland\StructType\AdePreparingBox_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: List avail pickups.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetIDs $parameters
     * @return \GlsPoland\StructType\AdePickup_GetIDsResponse|bool
     */
    public function adePickup_GetIDs(\GlsPoland\StructType\AdePickup_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignIDs $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignIDsResponse|bool
     */
    public function adePickup_GetConsignIDs(\GlsPoland\StructType\AdePickup_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: Get profiles info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdeProfile_GetIDs $parameters
     * @return \GlsPoland\StructType\AdeProfile_GetIDsResponse|bool
     */
    public function adeProfile_GetIDs(\GlsPoland\StructType\AdeProfile_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignPODs
     * Meta information extracted from the WSDL
     * - documentation: Get PODs pdf files from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsPoland\StructType\AdePickup_GetConsignPODs $parameters
     * @return \GlsPoland\StructType\AdePickup_GetConsignPODsResponse|bool
     */
    public function adePickup_GetConsignPODs(\GlsPoland\StructType\AdePickup_GetConsignPODs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignPODs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsPoland\StructType\AdePickup_GetConsignIDsResponse|\GlsPoland\StructType\AdePickup_GetConsignPODsResponse|\GlsPoland\StructType\AdePickup_GetIDsResponse|\GlsPoland\StructType\AdePreparingBox_GetConsignIDsResponse|\GlsPoland\StructType\AdeProfile_GetIDsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
