<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Run ServiceType
 * @subpackage Services
 */
class Run extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RunVRSCommandXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $msgStr
     * @return string|bool
     */
    public function RunVRSCommandXml($msgStr)
    {
        try {
            $this->setResult($this->getSoapClient()->RunVRSCommandXml($msgStr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RunVRSCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VrsXmlRequest $msg
     * @return string|bool
     */
    public function RunVRSCommand(\StructType\VrsXmlRequest $msg)
    {
        try {
            $this->setResult($this->getSoapClient()->RunVRSCommand($msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
