<?php

namespace TaxyTrack\TaxyTrackService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ TaxyTrackService
 * @package TaxyTrack
 * @subpackage Services
 */
class TaxyTrackREAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TaxyTrack\TaxyTrackStruct\TaxyTrackREAD $parameters
     * @return \TaxyTrack\TaxyTrackStruct\TaxyTrackREADResponse|bool
     */
    public function READ(\TaxyTrack\TaxyTrackStruct\TaxyTrackREAD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->READ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TaxyTrack\TaxyTrackStruct\TaxyTrackREADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
