<?php

namespace Taxy\TaxyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ TaxyService
 * @package Taxy
 * @subpackage Services
 */
class TaxyREAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Taxy\TaxyStruct\TaxyREAD $parameters
     * @return \Taxy\TaxyStruct\TaxyREADResponse|bool
     */
    public function READ(\Taxy\TaxyStruct\TaxyREAD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->READ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
