<?php

namespace Taxy\TaxyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READResponse TaxyStruct
 * @package Taxy
 * @subpackage Structs
 */
class TaxyREADResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int
     */
    public $st_flag;
    /**
     * The st_title
     * @var string
     */
    public $st_title;
    /**
     * The pod_date
     * @var string
     */
    public $pod_date;
    /**
     * The pod_time
     * @var string
     */
    public $pod_time;
    /**
     * The pod_name
     * @var string
     */
    public $pod_name;
    /**
     * The tt_rec
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \Taxy\TaxyStruct\TaxyTt_rec[]
     */
    public $tt_rec;
    /**
     * Constructor method for READResponse
     * @uses TaxyREADResponse::setSt_flag()
     * @uses TaxyREADResponse::setSt_title()
     * @uses TaxyREADResponse::setPod_date()
     * @uses TaxyREADResponse::setPod_time()
     * @uses TaxyREADResponse::setPod_name()
     * @uses TaxyREADResponse::setTt_rec()
     * @param int $st_flag
     * @param string $st_title
     * @param string $pod_date
     * @param string $pod_time
     * @param string $pod_name
     * @param \Taxy\TaxyStruct\TaxyTt_rec[] $tt_rec
     */
    public function __construct($st_flag = null, $st_title = null, $pod_date = null, $pod_time = null, $pod_name = null, array $tt_rec = array())
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setPod_date($pod_date)
            ->setPod_time($pod_time)
            ->setPod_name($pod_name)
            ->setTt_rec($tt_rec);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag()
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setSt_flag($st_flag = null)
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title()
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setSt_title($st_title = null)
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        return $this;
    }
    /**
     * Get pod_date value
     * @return string|null
     */
    public function getPod_date()
    {
        return $this->pod_date;
    }
    /**
     * Set pod_date value
     * @param string $pod_date
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setPod_date($pod_date = null)
    {
        // validation for constraint: string
        if (!is_null($pod_date) && !is_string($pod_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_date, true), gettype($pod_date)), __LINE__);
        }
        $this->pod_date = $pod_date;
        return $this;
    }
    /**
     * Get pod_time value
     * @return string|null
     */
    public function getPod_time()
    {
        return $this->pod_time;
    }
    /**
     * Set pod_time value
     * @param string $pod_time
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setPod_time($pod_time = null)
    {
        // validation for constraint: string
        if (!is_null($pod_time) && !is_string($pod_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_time, true), gettype($pod_time)), __LINE__);
        }
        $this->pod_time = $pod_time;
        return $this;
    }
    /**
     * Get pod_name value
     * @return string|null
     */
    public function getPod_name()
    {
        return $this->pod_name;
    }
    /**
     * Set pod_name value
     * @param string $pod_name
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setPod_name($pod_name = null)
    {
        // validation for constraint: string
        if (!is_null($pod_name) && !is_string($pod_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pod_name, true), gettype($pod_name)), __LINE__);
        }
        $this->pod_name = $pod_name;
        return $this;
    }
    /**
     * Get tt_rec value
     * @return \Taxy\TaxyStruct\TaxyTt_rec[]|null
     */
    public function getTt_rec()
    {
        return $this->tt_rec;
    }
    /**
     * This method is responsible for validating the values passed to the setTt_rec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTt_rec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTt_recForArrayConstraintsFromSetTt_rec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rEADResponseTt_recItem) {
            // validation for constraint: itemType
            if (!$rEADResponseTt_recItem instanceof \Taxy\TaxyStruct\TaxyTt_rec) {
                $invalidValues[] = is_object($rEADResponseTt_recItem) ? get_class($rEADResponseTt_recItem) : sprintf('%s(%s)', gettype($rEADResponseTt_recItem), var_export($rEADResponseTt_recItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tt_rec property can only contain items of type \Taxy\TaxyStruct\TaxyTt_rec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tt_rec value
     * @throws \InvalidArgumentException
     * @param \Taxy\TaxyStruct\TaxyTt_rec[] $tt_rec
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function setTt_rec(array $tt_rec = array())
    {
        // validation for constraint: array
        if ('' !== ($tt_recArrayErrorMessage = self::validateTt_recForArrayConstraintsFromSetTt_rec($tt_rec))) {
            throw new \InvalidArgumentException($tt_recArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($tt_rec) && count($tt_rec) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($tt_rec)), __LINE__);
        }
        $this->tt_rec = $tt_rec;
        return $this;
    }
    /**
     * Add item to tt_rec value
     * @throws \InvalidArgumentException
     * @param \Taxy\TaxyStruct\TaxyTt_rec $item
     * @return \Taxy\TaxyStruct\TaxyREADResponse
     */
    public function addToTt_rec(\Taxy\TaxyStruct\TaxyTt_rec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Taxy\TaxyStruct\TaxyTt_rec) {
            throw new \InvalidArgumentException(sprintf('The tt_rec property can only contain items of type \Taxy\TaxyStruct\TaxyTt_rec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->tt_rec) && count($this->tt_rec) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->tt_rec)), __LINE__);
        }
        $this->tt_rec[] = $item;
        return $this;
    }
}
