<?php

namespace Taxy\TaxyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for READ TaxyStruct
 * @package Taxy
 * @subpackage Structs
 */
class TaxyREAD extends AbstractStructBase
{
    /**
     * The user_details
     * @var \Taxy\TaxyStruct\TaxyUser_details
     */
    public $user_details;
    /**
     * The tt_code
     * @var string
     */
    public $tt_code;
    /**
     * Constructor method for READ
     * @uses TaxyREAD::setUser_details()
     * @uses TaxyREAD::setTt_code()
     * @param \Taxy\TaxyStruct\TaxyUser_details $user_details
     * @param string $tt_code
     */
    public function __construct(\Taxy\TaxyStruct\TaxyUser_details $user_details = null, $tt_code = null)
    {
        $this
            ->setUser_details($user_details)
            ->setTt_code($tt_code);
    }
    /**
     * Get user_details value
     * @return \Taxy\TaxyStruct\TaxyUser_details|null
     */
    public function getUser_details()
    {
        return $this->user_details;
    }
    /**
     * Set user_details value
     * @param \Taxy\TaxyStruct\TaxyUser_details $user_details
     * @return \Taxy\TaxyStruct\TaxyREAD
     */
    public function setUser_details(\Taxy\TaxyStruct\TaxyUser_details $user_details = null)
    {
        $this->user_details = $user_details;
        return $this;
    }
    /**
     * Get tt_code value
     * @return string|null
     */
    public function getTt_code()
    {
        return $this->tt_code;
    }
    /**
     * Set tt_code value
     * @param string $tt_code
     * @return \Taxy\TaxyStruct\TaxyREAD
     */
    public function setTt_code($tt_code = null)
    {
        // validation for constraint: string
        if (!is_null($tt_code) && !is_string($tt_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tt_code, true), gettype($tt_code)), __LINE__);
        }
        $this->tt_code = $tt_code;
        return $this;
    }
}
