<?php

namespace Taxy\TaxyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DELETE TaxyStruct
 * @package Taxy
 * @subpackage Structs
 */
class TaxyDELETE extends AbstractStructBase
{
    /**
     * The user_details
     * @var \Taxy\TaxyStruct\TaxyUser_details
     */
    public $user_details;
    /**
     * The vg_code
     * @var string
     */
    public $vg_code;
    /**
     * Constructor method for DELETE
     * @uses TaxyDELETE::setUser_details()
     * @uses TaxyDELETE::setVg_code()
     * @param \Taxy\TaxyStruct\TaxyUser_details $user_details
     * @param string $vg_code
     */
    public function __construct(\Taxy\TaxyStruct\TaxyUser_details $user_details = null, $vg_code = null)
    {
        $this
            ->setUser_details($user_details)
            ->setVg_code($vg_code);
    }
    /**
     * Get user_details value
     * @return \Taxy\TaxyStruct\TaxyUser_details|null
     */
    public function getUser_details()
    {
        return $this->user_details;
    }
    /**
     * Set user_details value
     * @param \Taxy\TaxyStruct\TaxyUser_details $user_details
     * @return \Taxy\TaxyStruct\TaxyDELETE
     */
    public function setUser_details(\Taxy\TaxyStruct\TaxyUser_details $user_details = null)
    {
        $this->user_details = $user_details;
        return $this;
    }
    /**
     * Get vg_code value
     * @return string|null
     */
    public function getVg_code()
    {
        return $this->vg_code;
    }
    /**
     * Set vg_code value
     * @param string $vg_code
     * @return \Taxy\TaxyStruct\TaxyDELETE
     */
    public function setVg_code($vg_code = null)
    {
        // validation for constraint: string
        if (!is_null($vg_code) && !is_string($vg_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vg_code, true), gettype($vg_code)), __LINE__);
        }
        $this->vg_code = $vg_code;
        return $this;
    }
}
