<?php

namespace Taxy\TaxyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DELETEResponse TaxyStruct
 * @package Taxy
 * @subpackage Structs
 */
class TaxyDELETEResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int
     */
    public $st_flag;
    /**
     * The st_title
     * @var string
     */
    public $st_title;
    /**
     * Constructor method for DELETEResponse
     * @uses TaxyDELETEResponse::setSt_flag()
     * @uses TaxyDELETEResponse::setSt_title()
     * @param int $st_flag
     * @param string $st_title
     */
    public function __construct($st_flag = null, $st_title = null)
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag()
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \Taxy\TaxyStruct\TaxyDELETEResponse
     */
    public function setSt_flag($st_flag = null)
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title()
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \Taxy\TaxyStruct\TaxyDELETEResponse
     */
    public function setSt_title($st_title = null)
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        return $this;
    }
}
