<?php

namespace TaxyPrint\TaxyPrintService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for PRINT TaxyPrintService
 * @package TaxyPrint
 * @subpackage Services
 */
class TaxyPrintPRINT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PRINT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TaxyPrint\TaxyPrintStruct\TaxyPrintPRINT $parameters
     * @return \TaxyPrint\TaxyPrintStruct\TaxyPrintPRINTResponse|bool
     */
    public function _PRINT(\TaxyPrint\TaxyPrintStruct\TaxyPrintPRINT $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PRINT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TaxyPrint\TaxyPrintStruct\TaxyPrintPRINTResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
