<?php

namespace Taxy\TaxyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PRINT TaxyStruct
 * @package Taxy
 * @subpackage Structs
 */
class TaxyPRINT extends AbstractStructBase
{
    /**
     * The user_code
     * @var string
     */
    public $user_code;
    /**
     * The user_pass
     * @var string
     */
    public $user_pass;
    /**
     * The pel_code
     * @var string
     */
    public $pel_code;
    /**
     * The vg_code
     * @var string
     */
    public $vg_code;
    /**
     * Constructor method for PRINT
     * @uses TaxyPRINT::setUser_code()
     * @uses TaxyPRINT::setUser_pass()
     * @uses TaxyPRINT::setPel_code()
     * @uses TaxyPRINT::setVg_code()
     * @param string $user_code
     * @param string $user_pass
     * @param string $pel_code
     * @param string $vg_code
     */
    public function __construct($user_code = null, $user_pass = null, $pel_code = null, $vg_code = null)
    {
        $this
            ->setUser_code($user_code)
            ->setUser_pass($user_pass)
            ->setPel_code($pel_code)
            ->setVg_code($vg_code);
    }
    /**
     * Get user_code value
     * @return string|null
     */
    public function getUser_code()
    {
        return $this->user_code;
    }
    /**
     * Set user_code value
     * @param string $user_code
     * @return \Taxy\TaxyStruct\TaxyPRINT
     */
    public function setUser_code($user_code = null)
    {
        // validation for constraint: string
        if (!is_null($user_code) && !is_string($user_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_code, true), gettype($user_code)), __LINE__);
        }
        $this->user_code = $user_code;
        return $this;
    }
    /**
     * Get user_pass value
     * @return string|null
     */
    public function getUser_pass()
    {
        return $this->user_pass;
    }
    /**
     * Set user_pass value
     * @param string $user_pass
     * @return \Taxy\TaxyStruct\TaxyPRINT
     */
    public function setUser_pass($user_pass = null)
    {
        // validation for constraint: string
        if (!is_null($user_pass) && !is_string($user_pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_pass, true), gettype($user_pass)), __LINE__);
        }
        $this->user_pass = $user_pass;
        return $this;
    }
    /**
     * Get pel_code value
     * @return string|null
     */
    public function getPel_code()
    {
        return $this->pel_code;
    }
    /**
     * Set pel_code value
     * @param string $pel_code
     * @return \Taxy\TaxyStruct\TaxyPRINT
     */
    public function setPel_code($pel_code = null)
    {
        // validation for constraint: string
        if (!is_null($pel_code) && !is_string($pel_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pel_code, true), gettype($pel_code)), __LINE__);
        }
        $this->pel_code = $pel_code;
        return $this;
    }
    /**
     * Get vg_code value
     * @return string|null
     */
    public function getVg_code()
    {
        return $this->vg_code;
    }
    /**
     * Set vg_code value
     * @param string $vg_code
     * @return \Taxy\TaxyStruct\TaxyPRINT
     */
    public function setVg_code($vg_code = null)
    {
        // validation for constraint: string
        if (!is_null($vg_code) && !is_string($vg_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vg_code, true), gettype($vg_code)), __LINE__);
        }
        $this->vg_code = $vg_code;
        return $this;
    }
}
